﻿# You can place the script of your game in this file.

# Declare images below this line, using the image statement.
# eg. image eileen happy = "eileen_happy.png"

image bg black ="blacksc.png"
image bg home = "FDscene1.png"
image bg gate = "SFDbg1.png"
image bg path = "SFDbg2.png"
image bg altar = "SFDAltar.png"
image cg boy1 = "SFDCG1p1.png"
image cg boy2 = "SFDCG1p2.png"
image cg maid = "SFDCG2.png"
image cg bard = "SFDCG3.png"
image cg heidi = "SFDCG4.png"
image cg heidi2 = "SFDCG4p2.png"
image cg wiz = "SFDCG5.png"
image cg battle = "SFDCG6.png"
image cg normal = "SFDCG7.png"
image cg good = "SFDCG8.png"
image cg true = "SFDCG9.png"
image cg ocean = "SFDCG10.png"

image l norm = "LeeNorm.png"
image l happy = "LeeHappy.png"
image l angry = "LeeAngry.png"
image l hurt = "LeeHurt.png"
image l shock = "LeeShock.png"
image l sad = "LeeSad.png"
image e = "Elder.png"
image h norm = "HeidiNorm.png"
image h happy = "HeidiHappy.png"
image h angry = "HeidiAngry.png"
image h hurt = "HeidiHurt.png"
image h shock = "HeidiShock.png"
image h sad = "HeidiSad.png"
image c norm = "ClaraNorm.png"
image c happy = "ClaraHappy.png"
image c angry = "ClaraAngry.png"
image c shock = "ClaraShock.png"
image c sad = "ClaraSad.png"
image a norm = "ApolloNorm.png"
image a happy = "ApolloHappy.png"
image a angry = "ApolloSad.png"
image a shock = "ApolloShock.png"
image a evil = "ApolloEvil.png"
image w norm = "WizardNorm.png"
image w happy = "WizardHappy.png"
image w angry = "WizardAngry.png"
image w hurt = "WizardHurt.png"
image w shock = "WizardShock.png"
image w sad = "WizardSad.png"
image s aft = "Shadow1.png"
image s bef = "Shadow2.png"

# Declare characters used by this game.
define m = Character('Miyu', color="#000000")
define b = Character('Boy', color="#000000")
define e = Character('Elder', color="#000000")
define h = Character('Heidi', color="#000000")
define l = Character('Lee', color="#000000")
define c = Character('Clara', color="#000000")
define a = Character('Apollo', color="#000000")
define s = Character('Shadow', color="#000000")
define w = Character('Wizard', color="#000000")
define n = Character('???', color="#000000")
define v = Character('Voice', color="#000000")

init:
    $ midleft = Position(xpos=200)
    $ midright = Position(xpos=600)
    image splash = "ATpresent.png"

label splashscreen:
    $ renpy.pause(0)
    scene black 
    with Pause(0.5)
    
    show splash 
    with dissolve
    with Pause(3.0)
    
    scene black 
    with dissolve
    with Pause(1.0)

    return

# The game starts here.

label start:
    $ gamepoints = 0
    $ question = False
     
    $ frame = 1
    scene bg black
    "The world outside is big and scary"
    "The world outside is dangerous"
    "I grew up hearing tales of the advancing world outside our forest"
    "The forest guardian, Heidi, sealed our forests during a time of war"
    "Since then... no one has come and no one has left this place"
    "It was the day of the festival 10 years later, when it would all change"
    "When people came once more..."
    
    scene bg home
    with dissolve
    $ frame = 3
    m "Finally! The day of the festival! I wonder what I should give Heidi this year...?"
    $ frame = 1
    "A light knocking sound comes from outside"
    n "Miyu! Miyu are you in?"
    $ frame = 7
    m "Elder?"
    $ frame = 1
    window show
    show e with moveinleft
    "An elderly man steps in with a tone of panic in his voice"
    e "Something has happened! I sense there are other presences in the forest!"
    $ frame = 7
    m "That's impossible! Heidi has had this place sealed for 10 years now!"
    $ frame = 1
    e "That's the other problem... Heidi... I can't find her..."
    $ frame = 7
    m "W... what?! Heidi's missing?!"
    $ frame = 1
    e "The village would be in uproar if they found out. You're the closest to Heidi out of all of us but..."
    e "...I don't want you to venture out when it might be dangerous. At the same time... I can't think of anyone else who could find her..."
    $ frame = 5
    m "I understand. I'll try looking for Heidi."
    $ frame = 1
    e "Really?"
    $ frame = 5
    m "I don't know what I'd do if Heidi was in danger... I'll find her. I promise."
    $ frame = 1
    e "Thank you. Please take care and don't forget your training."
    $ frame = 5
    m "I'll be back soon! (Heidi... where could you be...?)"
    hide e
    $ frame = 1
    "Miyu grabs her sword and leaves the house within seconds"
    scene bg gate
    $ frame = 6
    m "Heidi! Heidi! Huh? She's really not responding..."
    $ frame = 7
    m "Uwah!"
    $ frame = 1
    scene cg boy1 with fade
    m "A dead guy?!"
    m "No, no. Think about this calmly Miyu. He's just unconscious."
    menu:
        m "What should I do?"
        "Wake him up":
            $ gamepoints += 1
        "Move away":
            $ gamepoints += 0
    b "Just... another 5 minutes..."
    scene cg boy2
    m "Eep!"
    scene bg gate with fade
    show l shock
    b "Wait? Who are you?!"
    $ frame = 7
    m "I... I should ask y... you that... trespasser!"
    $ frame = 1
    b "Trespasser...? Now that you mention it, where am I?"
    $ frame = 6
    m "Forests... It's called Heidi's forest"
    $ frame = 1
    b "A forest? So are you one of those Forest Dwellers?"
    $ frame = 7
    m "Forest Dwellers? I've never heard of that before."
    show l hurt
    $ frame = 1
    b "I... I'm...! Ugh!"
    $ frame = 7
    m "Hey! What's wrong? Are you alright?"
    $ frame = 1
    b "I can't remember anything! What... what was I doing here?"
    n "Oh great another pesky child"
    $ frame = 2
    m "Who goes there?"
    $ frame = 1
    "A large figure approaches, the sun glaring over his shoulder"
    window show
    show s bef at left
    show l hurt at midright
    with moveinleft
    s "Such a classic line. Hand the boy over and I may spare you."
    $ frame = 2
    m "'May' spare me? That doesn't give me much confidence that you WILL spare me."
    $ frame = 1
    s "I don't have time for this. If you're going to think about it, I may as well devour you with him."
    "The shadow approaches Miyu and the boy slowly"
    menu:
        m "(He's serious... should I leave him?)"
        "Leave the boy":
            jump bad_end
        "Don't hand him over":
            $ gamepoints += 1
            jump shadow_lurking
            
label bad_end:
    $ frame = 3
    m "Uh... sure?"
    $ frame = 1
    show l angry at midright
    b "Wait what?!"
    s "Wise choice. But since you've seen me, I won't be letting you go either."
    $ frame = 6
    m "(I should have expected this)"
    $ frame = 1
    scene bg black with fade
    "The two children were never heard from again. Rumour has it that their screams can still be heard echoing the forests"
    "You got the bad end... try again?"
    return
    
label shadow_lurking:
    $ frame = 2
    m "Stay away!"
    $ frame = 1
    v "Run!"
    $ frame = 7
    m "Heidi...?"
    $ frame = 2
    m "Get up! We gotta go!"
    $ frame = 1
    show l shock at midright
    b "Where?"
    $ frame = 2
    m "Just run!"
    $ frame = 1
    s "You...! What the...?!"
    "The trees begin to shift and engulf the shadow, pulling him away"
    window show
    hide s bef with moveoutleft
    show l shock at center with moveinright
    b "Did... those trees just move?!"
    $ frame = 5
    m "Well the forest IS alive."
    $ frame = 1
    b "Alive?"
    v "Exactly! Every tree in this forest is a part of me."
    $ frame = 2
    m "Heidi! Come out already!"
    $ frame = 1
    v "Okay, okay! Sorry I took so long."
    "A bright light glows from behind Miyu"
    scene cg heidi with fade
    b "WOAH!"
    m "Well what happened? The Elder couldn't contact you either."
    h "I was knocked out for a bit. Someone broke my seal."
    b "A CREEPY OLD GHOST JUST CAME OUT OF A... A TREE!"
    scene cg heidi2
    h "Creepy... OLD... ghost.... you say?"
    m "Hei... Heidi you're ch... ch... choking me!"
    b "Uwah! Sorry! You're actually very, VERY pretty!"
    h "That's better."
    scene bg gate with fade
    show h norm at midright
    show l norm at midleft
    h "I'm Heidi, the protector of this place. So who exactly is the kid?"
    $ frame = 6
    m "He was unconscious at the entrance. That beast wanted him."
    $ frame = 1
    show l sad
    b "I don't remember anything either..."
    jump who_is_he

label who_is_he:
    show l norm
    show h norm
    $ frame = 1
    menu:
        m "(Maybe if I directly ask him some questions)"
        "His name":
            show l hurt
            b "I can't remember... All I recall is waking up and meeting you guys."
            jump who_is_he
        "The Shadow":
            "He appears to be in deep thought"
            show l sad
            b "He was trying to eat me... I called for someone to help me and kept running..."
            show h shock
            h "Someone must have broken my seal after you cried for help."
            h "I remember hearing the voice of a young boy outside the forest."
            jump who_is_he
        "His clothes":
            show l shock
            b "My clothes...?"
            show h happy
            h "Well spotted Miyu! As you can see, your clothes are quite different from ours."
            b "Oh!"
            show h norm
            show l norm
            h "It appears to be some kind of uniform... I'm sure I remember that insignia from 10 years ago..."
            show h sad
            h "...one of the kingdoms from the war..."
            show l shock
            b "Oh! The war 10 years ago. I was too young to remember, but I recall crying when dad..."
            show l hurt
            b "Wait... who was my Dad?"
            $ frame = 6
            m "(His father must have taken part in the war)"
            $ frame = 5
            m "It's okay. We'll come back to this later."
            $ frame = 1
            h "Good idea."
            jump who_is_he
        "Move on":
            pass
    show h norm
    show l norm
    h "I don't think we'll be able to figure much out about you yet. Miyu, take him to the altar."
    h "My powers are strongest there, and I don't want the village getting involved."
    $ frame = 7
    m "What about you?"
    $ frame = 1
    show h angry
    h "I'm going to teach that beast a lesson!"
    show h happy
    h "See you there!"
    $ frame = 7
    m "Wait!"
    $ frame = 1
    window show
    hide h happy with moveoutleft
    show l norm at center with moveinleft
    "Heidi flies in the direction the shadow was dragged off earlier"
    b "What does she mean by the altar?"
    $ frame = 5
    m "It's the place where this magic orb lies. There's some legend about it being the source of Heidi's powers and it keeps this forest alive."
    $ frame = 1
    b "So... when Heidi says 'seal'... is it true people can't actually come and leave?"
    $ frame = 5
    m "Yeah... You said we were 'Forest Dwellers', what does it mean?"
    $ frame = 1
    show l happy
    b "It means you're at one with the forest. It's what we call you, though I guess it's just for stories."
    b "I always hear how people lived in a forest and never left because you were 'hiding'."
    $ frame = 3
    m "It's pretty close to the truth. I've never been outside!"
    m "I always wonder what it's like... but I'm scared because all I ever hear is the word 'dangerous'."
    $ frame = 1
    show l norm
    b "But... it's surely dangerous here too right?"
    n "Oh it's dangerous alright."
    window show
    show s bef at left with moveinleft
    show l shock
    $ frame = 7
    m "!!!"
    $ frame = 1
    window show
    hide s bef with moveoutright
    show l angry
    b "It ran...!"
    menu:
        m "It went in the direction we're supposed to head..."
        "Make chase":
            $ gamepoints -= 1
            jump meet_bard
        "Take another route":
            $ gamepoints += 1
            jump meet_maid
            
label meet_bard:
    $ frame = 2
    m "We're going after it!"
    $ frame = 1
    show l angry
    b "Are you mad?!"
    $ frame = 2
    m "It'll kill us if we don't stop it!"
    $ frame = 1
    scene bg path with fade
    show l sad
    b "I don't like this... it's really quiet..."
    $ frame = 6
    m "(He's right, what was I thinking... This could have been a trap.)"
    $ frame = 1
    show l norm
    b "..."
    $ frame = 7
    m "What?"
    $ frame = 1
    b "You really want to protect this place don't you?"
    $ frame = 6
    m "Well of course... It's my home. At least... I've lived here most of my life."
    $ frame = 1
    show l shock
    b "Most of...?"
    $ frame = 5
    m "Before the war, I was found at the entrance to this place by Heidi. Along with this sword."
    m "I don't know who my real parents are."
    $ frame = 1
    show l sad
    b "Miyu..."
    n "Oh... are you residents of this forest?"
    show l shock
    "A man approaches from behind the trees"
    window show
    show a norm at midleft
    show l shock at midright
    with moveinleft
    $ frame = 7
    m "(Another person?!) Who are you?"
    $ frame = 1
    n "Ah, how rude of me!"
    scene cg bard with fade
    n "I am The Great Apollo, a travelling bard looking for inspiration on my music!"
    m "...The Great...?"
    b "Oh wow! Did you hear that Miyu? He must be famous!"
    m "I beg to differ."
    a "Tsk, tsk. Come on my little petal! How about I serenade for you?"
    m "Please don't."
    b "Aww! But I want to hear a song!"
    m "(Why am I here again?)"
    scene bg path with fade
    show a happy at midleft
    show l happy at midright
    a "Anyway, what's with that sword? A young lady shouldn't carry that!"
    $ frame = 7
    m "Don't!"
    $ frame = 1
    "As Apollo reaches for the sword, it glows a raging red. Apollo jumps back in shock"
    show a shock
    show l shock
    a "What--?"
    $ frame = 4
    m "The sword burns or shocks anyone who comes into contact with it... except me and Heidi."
    $ frame = 1
    a "I... I see."
    show a norm
    show l norm
    a "So about you two..."
    m "(I better answer carefully)"
    menu:
        a "Who are you?"
        "Answer truthfully":
            $ gamepoints += 0
            $ frame = 5
            m "I'm Miyu, and I live here."
            $ frame = 1
            b "And I have no memory!"
            show a angry
            a "No memory...? You poor thing!"
            pass
        "Be defensive":
            $ gamepoints += 1
            $ frame = 5
            m "I'm Miyu, but as for who he is I'm not inclined to say."
            $ frame = 1
            show l shock
            b "Well if Miyu isn't saying then I'm not..."
            show a angry
            a "Fair enough."
            pass
        "Lie":
            $ gamepoints -= 1
            $ frame = 3
            m "I'm Maria!"
            $ frame = 1
            show a angry
            a "Don't lie! He said your name was Miyu earlier!"
            $ frame = 6
            m "(That was a bad move)"
            $ frame = 1
            show l sad
            b "Oops..."
            pass
    show a norm
    show l norm
    menu:
        a "So what are you two going to do now?"
        "Try to move on":
            $ gamepoints += 0
            show l norm
            show a norm
            $ frame = 5
            m "Urm, just going to find a way out... so if you excuse us..."
            $ frame = 1
            show a happy
            a "Oh! Well The Great Apollo will join you then!"
            $ frame = 7
            m "What?"
            $ frame = 1
            a "Actually, I was hoping to meet the beautiful guardian and let her guide me out but in the end... I'm lost!"
            b "Miyu! We may as well let him come!"
            $ frame = 2
            m "(What a happy go lucky guy... but I guess I haven't got a choice now)"
            $ frame = 1
            pass
        "Ask Apollo to join you":
            $ gamepoints += 1
            $ frame = 5
            m "(It'll be better if I can keep an eye on him) Apollo? Why not come with us?"
            $ frame = 1
            show a happy
            show l shock
            a "I thought you'd never ask!"
            b "Miyu...?"
            "Miyu whispers to the boy"
            $ frame = 5
            m "I don't trust him... but he'll follow us anyway."
            $ frame = 1
            show l norm
            b "Ah, okay"
            pass
        
label ask_apollo:
    show l norm
    show a norm
    $ frame = 1
    menu:
        m "(May as well use the opportunity to ask some questions while we walk)"
        "Where Apollo's from":
            $ question = True
            a "Interested in me?"
            $ frame = 2
            m "..."
            $ frame = 1
            show a happy
            a "Okay, okay! Don't glare like that. I'm from a kingdom called Everre"
            show l shock
            b "Ah! I... I remember! I'm from there!"
            $ frame = 7
            m "Really?"
            $ frame = 1
            show l happy
            b "Yeah! I'm pretty sure of it!"
            a "Interesting..."
            jump ask_apollo
        "The insignia on the boy's clothes":
            show a happy
            a "Of course I'd know the insignia of my own home!"
            $ frame = 7
            m "Anything else you can say? About his clothes?"
            $ frame = 1
            show a norm
            a "It looks like one of the officer uniforms."
            $ frame = 7
            m "(There's no way someone his age could be an officer!!)"
            $ frame = 1
            b "Now that you mention it, I think there was a castle I was at."
            $ frame = 7
            m "(There's something off about this...)"
            $ frame = 1
            jump ask_apollo
        "Everre" if question == True:
            a "Everre is a small kingdom right by here! It was originally part of another kingdom called Rexwell."
            show l shock
            b "The war was for Everre's independence right?"
            a "That's right!"
            show l happy
            b "Everre won and Dad...!"
            show l hurt
            b "Ugh!"
            $ frame = 7
            m "Take it easy!"
            $ frame = 1
            show l sad
            b "Y... yeah..."
            jump ask_apollo
        "Move on":
            pass
    jump wizard_and_maid
    
label wizard_and_maid:
    scene bg altar with fade
    $ frame = 5
    m "Finally... Wait, is that...?"
    $ frame = 1
    show c angry at midright
    show w sad at midleft
    n "I said I'm looking for a young boy!"
    n "And I'm telling you I have no idea who you're talking about!"
    n "You were with him! I saw you!"
    hide w sad
    hide c angry
    "The voices between the two continue to rise until they notice the trio"
    show c shock at center
    n "Oh!"
    "The maid runs towards the trio and grabs the boy"
    window show
    show l shock at midleft
    show c shock at midright
    with moveinleft
    b "W...what?!"
    $ frame = 2
    m "Let him go!"
    $ frame = 1
    n "What are you doing here?! It's dangerous!"
    b "I don't even know who you are!"
    n "What...?"
    "The maid steps back and thinks for a moment"
    window show
    show c shock at right
    show l shock at center
    show a norm at left
    with moveinleft
    a "This young lad has a case of amnesia..."
    n "Amnesia?"
    $ frame = 5
    m "Um... miss?"
    $ frame = 1
    show c norm
    n "Oh I'm sorry... My name is Clara. I was looking for the boy there."
    b "Me?"
    hide a norm
    show w norm at left
    n "Well it seems like we have a bit of a situation here. There's the amnesiac boy, Clara who claims to know him and two others."
    $ frame = 2
    m "I'm Miyu, and if anything you're suspicious. Who are you?"
    $ frame = 1
    show l norm
    show w shock
    n "Oh... well I don't actually have a name. I'm an orphan, so just call me Wizard."
    hide c norm
    show l happy
    show a happy at right
    a "And I am The Great Apollo! Travelling bard and wonderful friend."
    $ frame = 2
    m "..."
    $ frame = 1
    show w happy
    show l norm
    show a norm
    w "Haha... why don't we take a step back and analyse the situation?"
    $ frame = 5
    m "...agreed."
    $ frame = 1
    show w norm
    "Miyu begins to explain the events thus far"
    show w sad
    w "So in other words, the truth really lies with the boy."
    show l shock
    b "How so?"
    show w norm
    w "I can offer to look into your memories. Naturally Clara claims to know you but you're unsure about Clara. Then there's also the fact Clara claims I kidnapped you."
    w "You haven't lost your memory. You're simply in a state of shock and I know how to help you remember... So?"
    $ frame = 5
    m "(The whole thing actually makes sense)"
    $ frame = 1
    show l sad
    b "Miyu... can you choose?"
    menu:
        m "You want me to decide?!"
        "Accept his offer":
            $ gamepoints += 1
            w "Very well"
            scene cg wiz with fade
            "The wizard begins chanting an unusual spell and the boy begins to react"
            if gamepoints >= 0:
                jump good_end1
            else:
                jump bad_end2
        "Decline his offer":
            $ gamepoints -= 1
            $ frame = 2
            m "No way! What if you're trying to trick us?"
            $ frame = 1
            hide l sad
            hide w norm
            hide a norm
            show a evil at center
            a "Heh heh..."
            b "...!"
            "Apollo suddenly grabs the boy from behind and glows a shadow black"
            if gamepoints >= 3:
                jump good_end2
            elif gamepoints >= 0:
                jump normal_end
            else:
                jump bad_end2
    
label meet_maid:
    $ frame = 2
    m "Quick, let's run the other way!"
    $ frame = 1
    show l shock
    b "O... okay!"
    scene bg path with fade
    show l norm
    b "I think we're okay for now."
    $ frame = 5
    m "Yeah... (Looks like it didn't follow us)"
    $ frame = 1
    b "..."
    $ frame = 7
    m "What?"
    $ frame = 1
    b "You really want to protect this place don't you?"
    $ frame = 6
    m "Well of course... It's my home. At least... I've lived here most of my life."
    $ frame = 1
    show l shock
    b "Most of...?"
    $ frame = 5
    m "Before the war, I was found at the entrance to this place by Heidi. Along with this sword."
    m "I don't know who my real parents are."
    $ frame = 1
    show l sad
    b "Miyu..."
    n "Ah! You...!"
    "A figure emerges from behind the trees"
    scene cg maid
    b "Me? ...Miyu!"
    m "What?"
    b "I get the feeling I've met her."
    scene bg path with fade
    show c norm at midleft
    show l shock at midright
    menu:
        m "(Could she be the enemy or a friend? She seems nice enough... What should we do?)"
        "Politely question her":
            $ gamepoints += 1
            show l norm
            $ frame = 5
            m "What brings you to our forest?"
            $ frame = 1
            n "I'm looking for someone"
            $ frame = 5
            m "I see. (So there might be even more strangers?!)"
            $ frame = 1
            b "I think we can trust her."
            $ frame = 3
            m "I think so too. (I don't sense any hostility from her)"
            $ frame = 1
            show c happy
            n "I'm sorry to have surprised you earlier. I'm quite lost at the moment. Could you show me to the exit?"
            pass
        "Draw your sword":
            $ gamepoints -= 1
            show l shock
            show c shock
            b "Miyu...!"
            "The maid raises her hands in defence"
            n "Please! I mean you no harm, and I have no weapons on me either."
            $ frame = 2
            m "..."
            $ frame = 1
            "Miyu puts her sword away, bowing apologetically"
            $ frame = 6
            m "I'm sorry, that was hasty of me. I don't deal well with strangers..."
            $ frame = 1
            show c sad
            n "I suppose that's understandable"
            $ frame = 6
            m "(I could have put us in more danger had she been the enemy)"
            $ frame = 1
            show l norm
            b "Moving on... um..."
            n "Ah, forgive me for staring. I'm currently looking for someone."
            $ frame = 5
            m "I see..."
            $ frame = 1
            pass
        "Stand in silence":
            $ gamepoints += 0
            show c norm
            show l norm
            n "I'm sorry. I was quite surprised to see children here."
            $ frame = 7
            m "I'm surprised to find a maid here."
            $ frame = 1
            n "Do you perhaps live here?"
            $ frame = 5
            m "I do. This boy doesn't."
            $ frame = 1
            n "I see... You both seem shaken. Is something the matter?"
            $ frame = 7
            m "For the first time in 10 years, people have come here. Naturally I'm shaken."
            $ frame = 1
            b "Miyu, I think we can trust her."
            $ frame = 7
            m "Huh?"
            $ frame = 1
            show c happy
            n "I'm aware you're both suspicious of me. The truth is I'm looking for someone."
            $ frame = 5
            m "(That beast is still in the forest...)"
            $ frame = 1
            pass
    show c norm
    show l norm
    menu:
        m "(What should I do?)"
        "Let her come with you":
            $ gamepoints += 1
            $ frame = 5
            m "There's a beast around so it's not safe alone. How about travelling with us?"
            $ frame = 1
            show c happy
            n "Thank you! It'll be much safer this way."
            $ frame = 5
            m "(If she tries to do anything I can keep an eye on her at least)"
            $ frame = 1
            n "My name is Clara."
            $ frame = 5
            m "I'm Miyu. This person... doesn't remember at the moment."
            $ frame = 1
            show l sad
            show c sad
            c "I see..."
            pass
        "Try to leave":
            $ gamepoints += 0
            $ frame = 3
            m "Well we'll be moving on now..."
            $ frame = 1
            show l shock
            b "Miyu! That thing is still out there somewhere!"
            $ frame = 6
            m "..."
            $ frame = 1
            n "If it's not too much trouble... I'd like to join you. It'll be safer with more of us anyway."
            $ frame = 6
            m "Alright..."
            $ frame = 1
            show c happy
            show l norm
            n "My name is Clara."
            $ frame = 5
            m "I'm Miyu. This person... doesn't remember at the moment."
            $ frame = 1
            show c sad
            show l sad
            c "I see..."
            pass
label ask_clara:
    show c norm
    show l norm
    $ frame = 1
    menu:
        m "(I should use the chance to ask some questions while we walk)"
        "Where Clara's from":
            $ question = True
            c "The grand kingdom of Everre."
            show l shock
            b "Ah! I... I remember! I'm from there!"
            $ frame = 7
            m "Really?"
            $ frame = 1
            c "Well I would expect you are. You have the same insignia on your uniform."
            $ frame = 7
            m "..."
            $ frame = 1
            show l happy
            b "Now that you mention it. I was at a castle!"
            $ frame = 7
            m "(Just who are you?!)"
            $ frame = 1
            jump ask_clara
        "The person she's looking for":
            show c sad
            c "A very important person."
            $ frame = 5
            m "Anything else? His or her looks?"
            $ frame = 1
            b "Do you not want to say?"
            show c happy
            c "...I'm afraid that's all I can say."
            $ frame = 6
            m "(Hmm...)"
            $ frame = 1
            jump ask_clara
        "Everre" if question == True:
            c "Everre is a wonderful kingdom close to this forest. It recently won independence against the larger kingdom of Rexwell."
            show l shock
            b "I think Dad was in the war."
            c "Your father?"
            show l happy
            b "Everre won and Dad...!"
            show l hurt
            b "Ugh!"
            $ frame = 7
            m "Take it easy!"
            $ frame = 1
            show l sad
            b "Y... yeah..."
            c "..."
            jump ask_clara
        "Move on":
            pass
    jump wizard_and_bard
    
label wizard_and_bard:
    scene bg altar with fade
    $ frame = 5
    m "Finally... Wait, is that...?"
    $ frame = 1
    show a happy at midright
    show w angry at midleft
    n "...and then I sang my heart out and all the ladies came flooding my way!"
    n "Would you just leave...?"
    n "It's amazing right?!"
    hide a happy
    hide w angry
    "The voices between the two continue to rise until they notice the trio"
    show a norm at center
    n "Oh!"
    "The bard runs towards the trio and grabs Miyu's hands"
    $ frame = 7
    m "W... what?!"
    $ frame = 1
    n "Fair maiden! Would you listen to my song?"
    show l happy at midleft
    b "You can sing?"
    $ frame = 2
    m "I don't want to hear! Let me go!"
    $ frame = 1
    window show
    show a angry at right
    show l sad at center
    show c angry at left
    with moveinleft
    c "I don't want to hear it either."
    "The bard stands back and stares at the trio for a moment"
    show a norm
    show l norm
    show c norm
    n "Why are you all here anyway?"
    $ frame = 2
    m "We're running away from a giant beast. Care to tell me who YOU are?"
    $ frame = 1
    n "Ah of course... I... am The Great Apollo!"
    show l happy
    $ frame = 2
    m "(Why the dramatic pause...?)"
    $ frame = 1
    show l norm
    $ frame = 5
    m "How about you?"
    $ frame = 1
    "Miyu points to the robed man behind Apollo"
    hide a norm
    show w shock at right
    n "Oh... I'm a student wizard. I don't have a name so just call me Wizard."
    $ frame = 5
    m "Right... I'm Miyu and I live here. This is Clara and he..."
    $ frame = 1
    show c sad
    c "The boy suffers amnesia."
    w "Oh?"
    hide c sad
    window show
    show a happy at left with moveinleft
    a "Perhaps hearing one of my delightful songs will--"
    show a angry
    show l sad
    show w angry
    "A unanimous 'no' echoes from everyone except the boy"
    $ frame = 2
    m "I don't know why but I really don't want to hear you sing."
    $ frame = 1
    show w happy
    w "Haha... Why don't we take a step back and analyse the situation?"
    $ frame = 5
    m "...agreed"
    $ frame = 1
    show a norm
    show l norm
    show w norm
    "Miyu begins to explain the events thus far"
    show w sad
    w "So in other words, the truth really lies with the boy."
    show l shock
    b "How so?"
    show w norm
    w "I can offer to look into your memories. Naturally this beast is somewhere, even with us right now. We can also figure out your identity and what to do from there."
    w "You haven't lost your memory. You're simply in a state of shock and I know how to help you remember... So?"
    $ frame = 5
    m "(The whole thing actually makes sense)"
    $ frame = 1
    show l sad
    b "Miyu... can you choose?"
    menu:
        m "You want me to decide?!"
        "Accept his offer":
            $ gamepoints += 1
            w "Very well"
            scene cg wiz with fade
            "The wizard begins chanting an unusual spell and the boy begins to react"
            if gamepoints == 6:
                jump true_end
            elif gamepoints >= 0:
                jump good_end1
            else:
                jump bad_end2
        "Decline his offer":
            $ gamepoints -= 1
            $ frame = 2
            m "No way! What if you're trying to trick us?"
            $ frame = 1
            hide l sad
            hide w norm
            hide a norm
            show a evil at center
            a "Heh heh..."
            b "...!"
            "Apollo suddenly grabs the boy from behind and glows a shadow black"
            if gamepoints >= 3:
                jump good_end2
            elif gamepoints >= 0:
                jump normal_end
            else:
                jump bad_end2

label bad_end2:
    scene bg black
    "Before anyone could do anything, within a flash the boy is devoured from behind."
    "What happens next is a complete blur to those present... No traces or signs of anyone left..."
    "You got the bad end... try again?"
    return
    
label normal_end:
    a "Insignificant fools..."
    show c shock at left
    c "Apollo?!"
    $ frame = 2
    m "So it was you!"
    $ frame = 1
    hide c shock
    hide a evil
    "In a flash the clothes on Apollo begin to extend and tighten on him, forming a scale-like skin"
    show s aft at center with fade
    a "Phew... taking on the form of a human sure is annoying."
    show c sad at left
    c "Lee!"
    show l shock at right
    b "Lee...? Ah! My name!"
    $ frame = 7
    m "What?"
    $ frame = 1
    hide c sad
    show w norm at left
    w "Prince Lee Everre of the Everre kingdom?"
    $ frame = 7
    m "A prince?!"
    $ frame = 1
    a "Tut tut... I thought he'd make a nice snack seeing his magic potential..."
    a "...but then the sword that girl carries would make a wonderful gift as well!"
    $ frame = 7
    m "My... sword? This is just a normal sword!"
    $ frame = 1
    hide w norm
    hide s aft
    hide l shock
    v "That's enough!"
    "Within a flash the vines beneath Apollo entangle him and Lee runs to Clara"
    show h angry at center with fade
    h "You will bring no more trouble to this place!"
    "Heidi begins to chant something and the vines pull Apollo into the ground"
    "Within a few moments, Apollo is gone"
    window show
    show h angry at right
    show l sad at center
    show c sad at left
    with moveinleft
    h "Young prince, maid, and Wizard... please leave."
    $ frame = 6
    m "...!"
    $ frame = 1
    show c angry
    c "I understand... you do not wish any harm in your forests, correct?"
    show h sad
    h "It is sad... but it is also for the best."
    hide c angry
    show w sad at left
    w "We understand..."
    show l shock
    l "Clara!"
    hide w sad
    show c angry at left
    c "Your highness please! Let us leave..."
    $ frame = 6
    m "..."
    $ frame = 1
    scene bg black
    "Lee and Miyu glance at each other before respectfully bowing and parting their separate ways"
    "A few days later..."
    scene cg normal
    m "It has been a few days since the incident... Heidi sealed the forests once more."
    m "I wonder what Apollo wanted with my sword, why he wanted to take Lee and how did everyone enter the forest?"
    m "There's still so many unanswered questions..."
    m "Can I ever protect this place...?"
    "You got the normal end... try again?"
    return
    
label good_end1:
    scene bg altar with fade
    show l shock
    b "...I... My name was Lee and... Clara was my tutor!"
    show c sad at right
    c "Prince Lee!"
    $ frame = 7
    m "Prince?!"
    $ frame = 1
    show w norm at left
    w "It would appear he is the Prince of Everre. Prince Lee Everre, 2nd son of King Vince Everre."
    $ frame = 7
    m "So... the whole time I was with a prince."
    $ frame = 1
    hide l shock
    hide c sad
    hide w norm
    show a evil at center
    a "Haha... HAHA... It doesn't matter does it?"
    l "Huh?"
    hide a evil with fade
    "Apollo vanishes and grabs Lee from behind. His clothes begin to extend on his body, forming a scale-like skin"
    show s aft at center
    show l shock at left
    with fade
    a "Now that I have the boy, all I need is Miyu's sword!"
    $ frame = 2
    m "This is just a normal sword!"
    $ frame = 1
    show w angry at right
    w "Lee, duck!"
    l "Oh!"
    hide w angry
    hide s aft
    hide l shock
    "Wizard sends a flash of light at Apollo, causing him to push Lee into the altar"
    show l hurt at center
    l "Agh!"
    "Within a few seconds a light surrounds Lee. Apollo attempts to grab him..."
    show s aft at left with moveinleft
    "...but is pushed back by an invisible force!"
    hide s aft with moveoutleft
    show c angry at right
    c "What is this?"
    show w hurt at left
    w "Worry about it later! Help me finish him off!"
    "Clara draws a small dagger from her boots and lunges at Apollo, but it barely scratches him"
    "Wizard enchants a spell and a bright light covers the area. Apollo is nowhere to be seen"
    show w norm
    w "In the end, I could only teleport him to the depths of the Earth"
    show c shock at right
    c "Lee! Are you hurt?"
    l "I'm fine... what was that?"
    v "Oh my... I wasn't expecting this turnout."
    $ frame = 7
    m "Heidi!"
    $ frame = 1
    hide w norm
    show c norm
    show h norm at left with moveinleft
    h "It seems the Key Holder has appeared once more"
    show l shock
    l "Key Holder...?"
    h "To be honest, I thought Miyu was the Key Holder. Since the orb there reacts to her as well."
    $ frame = 7
    m "I was found here, right?"
    $ frame = 1
    show h happy
    h "Yes, you were. Alas, I am now in a pact with Lee. Should you ever need me, simply call my name."
    show l norm
    l "I don't quite understand, but okay."
    $ frame = 5
    m "I think she means if there are more dangers."
    $ frame = 1
    hide h happy
    show w norm at left
    w "It's quite possible there will be more than one beast after you young prince. It would be wise to take care."
    c "I will do everything I can as well prince."
    show l happy
    l "Thank you..."
    $ frame = 3
    m "Well we're safe now... That's what matters!"
    $ frame = 1
    l "Yeah!"
    scene bg black with fade
    "It has been a long day. After a few tearful goodbyes, everyone went their separate ways"
    "A few months later..."
    scene cg good with fade
    m "Oh! A letter from Lee!"
    l "How are you doing Miyu? Ever since I got back, I've had to go through a lot of training. Clara hasn't been going easy on me either!"
    l "Hey! Maybe you should come to the castle sometime with Wizard and Heidi. There's a festival next month!"
    l "Speaking of which, how is Wizard? I heard your village elder was training him like mad too."
    l "I hope you haven't skipped training either! You want to take the knight exam right?"
    l "Speak soon!"
    m "A festival... that would be nice. I'll tell Wizard and Heidi later!"
    m "I'm glad we can still talk like this. Sending letters is pretty fun!"
    "You got the good end... try again?"
    return
    
label good_end2:
    a "Insignificant fools..."
    show c shock at left
    c "Apollo?!"
    $ frame = 2
    m "So it was you!"
    $ frame = 1
    hide c shock
    hide a evil
    "In a flash the clothes on Apollo begin to extend and tighten on him, forming a scale-like skin"
    show s aft at center with fade
    a "Phew... taking on the form of a human sure is annoying."
    show c sad at left
    c "Lee!"
    show l shock at right
    b "Lee...? Ah! My name! And you're my tutor Clara!"
    $ frame = 7
    m "What?"
    $ frame = 1
    hide c sad
    show w norm at left
    w "It would appear he is the Prince of Everre. Prince Lee Everre, 2nd son of King Vince Everre."
    $ frame = 7
    m "So... the whole time I was with a prince."
    $ frame = 1
    a "Now that I have the boy, all I need is Miyu's sword!"
    $ frame = 2
    m "This is just a normal sword!"
    $ frame = 1
    show w angry
    w "Lee, duck!"
    l "Oh!"
    hide w angry
    hide s aft
    hide l shock
    "Wizard sends a flash of light at Apollo, causing him to push Lee into the altar"
    show l hurt at center
    l "Agh!"
    "Within a few seconds a light surrounds Lee. Apollo attempts to grab him..."
    show s aft at left with moveinleft
    "...but is pushed back by an invisible force!"
    hide s aft with moveoutleft
    show c angry at right
    c "What is this?"
    show w hurt at left
    w "Worry about it later! Help me finish him off!"
    "Clara draws a small dagger from her boots and lunges at Apollo, but it barely scratches him"
    "Wizard enchants a spell and a bright light covers the area. Apollo is nowhere to be seen"
    show w norm
    w "In the end, I could only teleport him to the depths of the Earth"
    show c shock
    c "Lee! Are you hurt?"
    l "I'm fine... what was that?"
    v "Oh my... I wasn't expecting this turnout."
    $ frame = 7
    m "Heidi!"
    $ frame = 1
    hide w norm
    show c norm
    show h norm at left with moveinleft
    h "It seems the Key Holder has appeared once more"
    show l shock
    l "Key Holder...?"
    h "To be honest, I thought Miyu was the Key Holder. Since the orb there reacts to her as well."
    $ frame = 7
    m "I was found here, right?"
    $ frame = 1
    show h happy
    h "Yes, you were. Alas, I am now in a pact with Lee. Should you ever need me, simply call my name."
    show l norm
    l "I don't quite understand, but okay."
    $ frame = 5
    m "I think she means if there are more dangers."
    $ frame = 1
    hide h happy
    show w norm at left
    w "It's quite possible there will be more than one beast after you young prince. It would be wise to take care."
    c "I will do everything I can as well prince."
    show l happy
    l "Thank you..."
    $ frame = 3
    m "Well we're safe now... That's what matters!"
    $ frame = 1
    l "Yeah!"
    scene bg black with fade
    "It has been a long day. After a few tearful goodbyes, everyone went their separate ways"
    "A few months later..."
    scene cg good with fade
    m "Oh! A letter from Lee!"
    l "How are you doing Miyu? Ever since I got back, I've had to go through a lot of training. Clara hasn't been going easy on me either!"
    l "Hey! Maybe you should come to the castle sometime with Wizard and Heidi. There's a festival next month!"
    l "Speaking of which, how is Wizard? I heard your village elder was training him like mad too."
    l "I hope you haven't skipped training either! You want to take the knight exam right?"
    l "Speak soon!"
    m "A festival... that would be nice. I'll tell Wizard and Heidi later!"
    m "I'm glad we can still talk like this. Sending letters is pretty fun!"
    "You got the good end... try again?"
    return
    
label true_end:
    scene bg altar with fade
    show l shock
    b "...I... My name was Lee and... Clara was my tutor! Then the wizard helped me when I was running from that thing by opening the forest!"
    show w norm at left
    w "It worked. Glad you got your memories back, Prince Lee Everre."
    $ frame = 7
    m "Prince?!"
    $ frame = 1
    show c norm at right
    w "Prince Lee Everre, 2nd son of King Vince Everre."
    $ frame = 7
    m "So... the whole time I was with a prince."
    $ frame = 1
    hide l shock
    hide c norm
    hide w norm
    show a evil at center
    a "Haha... HAHA... It doesn't matter does it?"
    l "Huh?"
    hide a evil with fade
    "Apollo vanishes and grabs Lee from behind. His clothes begin to extend on his body, forming a scale-like skin"
    show s aft at center
    show l shock at left
    with fade
    a "Now that I have the boy, all I need is Miyu's sword!"
    $ frame = 2
    m "This is just a normal sword!"
    $ frame = 1
    show w angry at right
    w "Lee, duck!"
    l "Oh!"
    hide w angry
    hide s aft
    hide l shock
    "Wizard sends a flash of light at Apollo, causing him to push Lee into the altar"
    show l hurt at center
    l "Agh!"
    "Within a few seconds a light surrounds Lee. Apollo attempts to grab him..."
    window show
    show s aft at left with moveinleft
    "...but is pushed back by an invisible force!"
    window show
    hide s aft with moveoutleft
    $ frame = 4
    m "My... my back!"
    $ frame = 1
    "The sword on Miyu's back begins to glow a bright green"
    "The orb from the altar flashes and a small sphere fits into place in one of the unusual holders on her sword"
    $ frame = 4
    m "...!"
    $ frame = 1
    show w hurt at right
    w "Miyu! Use your sword on him!"
    $ frame = 7
    m "Wait what?!"
    $ frame = 1
    w "Trust me!"
    $ frame = 4
    m "(There's no way I can... but somehow...) Alright!"
    $ frame = 1
    "Miyu draws her sword and points it at Apollo"
    hide w hurt
    hide l hurt
    show s aft at center
    a "Tch...! Do you think that sword will scratch me? It's barely holding any power!"
    $ frame = 2
    m "We'll see!"
    $ frame = 1
    scene cg battle with fade
    "Miyu lunges at Apollo as he raises his claw. A sharp sound and cry of pain is heard as a flash of light emits from the two"
    m "I... won't let you hurt anyone!"
    a "...!"
    scene bg altar with fade
    "Apollo falls to the ground"
    a "How could... a mere weapon strike me at such weak power... Ke... HAHAHA!"
    a "I guess the power of the keys is much more than I thought. Then... I'll come back someday!"
    "Before the others have a chance to stop him. Apollo warps and vanishes from the area"
    "The once dark aura that filled the forests is now gone"
    $ frame = 7
    m "I... I did it..."
    $ frame = 4
    show l shock at center
    l "Miyu! Are you alright?!"
    $ frame = 1
    v "She's fine. The power just drained her energy a bit."
    $ frame = 4
    m "Heidi...?"
    $ frame = 1
    show h norm at left with moveinleft
    h "It seems the Key Holder has appeared once more"
    show l shock
    l "Key Holder...?"
    h "To be honest, I thought Miyu was the Key Holder. Since the orb there reacts to her as well."
    $ frame = 7
    m "I was found here, right?"
    $ frame = 1
    show h happy
    h "Yes, you were. Alas, I am now in a pact with Lee. Should you ever need me, simply call my name."
    show l norm
    l "I don't quite understand, but okay."
    $ frame = 5
    m "I think she means if there are more dangers."
    $ frame = 1
    hide h happy
    show w norm at left
    w "It's quite possible the beast will come after you again young prince. It would be wise to take care."
    show c norm at right
    c "I will do everything I can to protect you. Thank you Wizard for helping him as well."
    show w happy
    w "Of course."
    hide w happy
    show h happy at left
    h "Well then! It's been quite a day. Shall we all go to the village and celebrate?"
    $ frame = 7
    m "Oh! Your birthday!"
    $ frame = 1
    show c happy
    c "I don't see why not."
    hide h happy
    show w happy at left
    w "I would like to come as well."
    show l happy
    l "A festival? Yeah!"
    scene bg black with fade
    "The group leave the altar and head towards the village"
    "Later that evening..."
    scene cg true with fade
    m "Happy birthday Heidi!"
    h "Thank you Miyu!"
    l "This is the first time I've really enjoyed a festival. I'm usually stuck with my brother watching it!"
    m "Really? Then you should come every year to celebrate!"
    l "Yeah!"
    c "Well that also depends on your father. But you would sneak out anyway, right?"
    l "Hehe... yep..."
    "Wizard and Clara join the trio by the campfire"
    w "Alright! From today onwards I'm staying here."
    m "Really?"
    w "I just talked with Elder. He said he'd be willing to take me on as a student."
    c "And I just discussed with him about a possible trade here. For supplies and things."
    l "So... we'll be cooperating with them?"
    c "I still have to talk to the King about this. But I see no reason why not."
    m "Hey, can I come to Everre sometime?"
    l "Of course! In fact I hope you do come!"
    c "I see the young prince has met a valued friend during his time here."
    h "That's a good thing though. It'll be a nice change for Miyu too."
    m "(It's strange... I never thought I would be able to see the outside... but somewhere... I can't help but think there's more danger than ever...)"
    scene bg black with fade
    "The day ends peacefully in the forests. Miyu's doubt continues to linger and somewhere far away..."
    scene cg ocean with fade
    n "..."
    "To be continued..."
    "You got the true end... play again?"
    return
